<?php
//======================================================================
// Set timezone
date_default_timezone_set('Asia/Tehran');
// ⚙️ تنظیمات
$db_host = "localhost";
$db_user = ""; // یوزر دیتابیس
$db_pass = ""; // پسورد یوزر
$db_name = ""; // نام دیتابیس

$bot_token = ""; // توکن ربات تلگرامی که ساختید رو اینجا قرار بدید
$chat_id = ""; // آیدی عددی کانال تلگرامتون رو همراه با علامت - در اینجا قرار بدید.

$date = date("Y-m-d_H-i-s");
$today = date("Y/m/d");
$hour = date("H:i:s");
$dump_file = __DIR__ . "/../db_to_tg/db_backup_$date.sql";
//======================================================================

// 1. بکاپ گرفتن از دیتابیس
$dump_command = "mysqldump -h $db_host -u $db_user -p$db_pass $db_name > $dump_file";
exec($dump_command, $output, $result_code);

// بررسی خطا در بکاپ
if ($result_code !== 0 || !file_exists($dump_file)) {
    die("❌ خطا در گرفتن بکاپ از دیتابیس.");
}

// 2. ارسال فایل به تلگرام
$send_url = "https://api.telegram.org/bot$bot_token/sendDocument";
$post_fields = [
    'chat_id'   => $chat_id,
    'caption'   => "📦 بکاپ دیتابیس - $date\n📆 تاریخ: $today\n⏰ ساعت $hour",
    'document'  => new CURLFile($dump_file)
];

$ch = curl_init(); 
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type:multipart/form-data"]);
curl_setopt($ch, CURLOPT_URL, $send_url); 
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields); 
$result = curl_exec($ch);
curl_close($ch);

// 3. پاک کردن فایل بکاپ
unlink($dump_file);

echo "✅ بکاپ دیتابیس ارسال شد.";
?>
