# دیتابیس به تلگرام
این یک اسکریپت PHP هست که با استفاده از کرون جاب، یک بک آپ کامل از دیتابیس هاستتون می گیره و در یک کانال تلگرام خصوصی که فقط خودتون و اشخاصی که تعیین کردید عضو اون کانال هستند، ارسال می کند. قبل از ارائه توضیحات تکمیلی و نحوه راه اندازی، جا داره چند نکته رو بگم:
## قبل از استفاده بخوانید
- این اسکریپت روی هاست هایی که لوکیشنشون ایران هست کار نمی کنه. چون ایران تلگرام رو فیلتر کرده و نمی شه از طریق هاست های ایرانی به سرور های تلگرام درخواستی ارسال کرد. من دارم روی نسخه ای کار می کنم که هاست های ایرانی هم بتونن ازش استفاده کنن. درصورت موفقیت، به زودی در همین گیت هاب منتشر می کنم.
- این اسکریپت فقط از دیتابیسی که براش تعیین کردید بک آپ میگیره و نه از کل هاست. اگر چند دیتابیس مختلف روی یک هاست دارید، می تونید به ازای هر دیتابیس یک فایل بسازید که از اون دیتابیس خاص بک آپ بگیره.(کافی هست کد های فایل اصلی رو در اون فایل کپی پیست کنید.)
- این اسکریپت فقط برای دیتابیس هایی که حجمشون کمتر از 50 مگابایت هست کار می کنه. اگر حجم دیتابیستون بیش از 50 مگابایت هست، این اسکریپت به درستی اجرا نمی شه. سعی می کنم یک نسخه برای دیتابیس های سنگین هم منتشر کنم که البته این بستگی به میزان استقبال از همین نسخه فعلی داره.
- این اسکریپت با کرون جاب کار می کنه. یعنی هیچ محدودیت زمانی ای نداره. بسته به میل خودتون، می تونید جوری تنظیمش کنید که هر یک دقیقه یکبار از دیتابیس بک آپ بگیره یا هر یک ساعت یکبار یا هر زمانی که خودتون در نظر دارید. فقط قبلش با پشتیبانی سایت هاستینگ هماهنگ کنید که محدودیتی برای کرون جاب دارن یا نه. چون بعضی هاستینگا اگر چنین عملیاتی رو زیاد با هاستشون انجام بدید ممکنه هاستتون رو مسدود کنن.
- در نهایت، برای کار با این اسکریپت نیاز به دانش PHP پایه دارید. در حدی که بتونید چند متغیر رو مقداردهی کنید و یک فولدر در هاست ایجاد کنید. با این حال، اگر بلد نبودید هم مشکلی نیست. می تونید به من یا هر برنامه نویس دیگه ای بسپارید تا با دریافت مبلغی براتونر اه اندازیش  کنه.
## نحوه راه اندازی
راه اندازی این اسکریپت دو بخش داره. اول باید در اپلیکیشن تلگرام یک سری کارهارو انجام بدید، بعد در هاستتون.
### کارهایی که در تلگرام باید انجام بدیم
#### ساخت ربات تلگرام
اول باید با استفاده از BotFather یک ربات تلگرام بسازید. اگر این کار رو بلد نیستید، می تونید از ویدئو آموزشی زیر استفاده کنید:
- تماشا در آپارات: https://www.aparat.com/v/xjmgd8o
- تماشا در یوتیوب: فیلترشکنم وصل شد لینکشو کپی می کنم می ذارم:)
#### ساخت یک کانال خصوصی در تلگرام
یک کانال خصوصی در تلگرام ایجاد کنید و رباتی که ساختید رو در اون کانال ادمین کنید. اگر نیاز هست کسی از اعضای تیمتون هم به بک آپ های دیتابیس دسترسی داشته باشه، می تونید عضو اون کانال کنید. اما حواستون باشه هرگز این کانال رو عمومی نکنید و لینکش رو جایی منتشر نکنید.
#### دریافت آیدی عددی کانال
بعد از ساخت کانال، نیاز هست که آیدی عددی کانالتون رو دریافت کنید. برای این کار، کافی هست ربات @HTUserinfoBot رو یک لحظه ادمین اون کانال کنید، بعدش یک پیام در اون کانال ارسال کنید و پیام رو برای این ربات فوروارد کنید. بهتون اطلاعات کانال رو می ده که شامل ID هم هست. ID ای که بهتون داده رو کپی کنید که در مراحل بعدی بهش نیاز داریم.
### کارهایی که در هاست باید انجام بدیم
- فایل db_to_tg.php رو در هر مسری که خواستید در هاستتون آپلود کنید. کافیه در پوشه public_html باشه. 
- در کنار پوشه public_html(دقت کنید کنارش نه داخلش) یک پوشه به نام db_to_tg ایجاد کنید. این پوشه برای ذخیره سازی موقت فایل بکاپ هست.
- فایل db_to_tg.php رو به حالت ویرایش در بیارید. در ابتدای فایل با کد زیر موجه می شوید. تنظیمات مربوط به راه ندازی اسکریپت هست که الان با هم انجامش میدیم. 
```
//======================================================================
// Set timezone
date_default_timezone_set('Asia/Tehran');
// ⚙️ تنظیمات
$db_host = "localhost";
$db_user = ""; // یوزر دیتابیس
$db_pass = ""; // پسورد یوزر
$db_name = ""; // نام دیتابیس

$bot_token = ""; // توکن ربات تلگرامی که ساختید رو اینجا قرار بدید
$chat_id = ""; // آیدی عددی کانال تلگرامتون رو همراه با علامت - در اینجا قرار بدید.

$date = date("Y-m-d_H-i-s");
$today = date("Y/m/d");
$hour = date("H:i:s");
$dump_file = __DIR__ . "/../db_to_tg/db_backup_$date.sql";
//======================================================================
```
#### تنظیم منطقه زمانی
من با استفاده از تابع date_default_timezone_set منطقه زمانی رو روی تهران تنظیم کردم. اگر جایی جز ایران زندگی می کنید، می تونید روی منطقه زمانی خودتون تنظیمش کنید.
#### تنظیمات مربوط به دیتابیس
در متغیر های زیر، به ترتیب یوزرنیمی که به دیتابیس دسترسی داره، پسورد یوزرنیم و نام دیتابیستون رو وارد کنید:
```
$db_user = ""; // یوزر دیتابیس
$db_pass = ""; // پسورد یوزر
$db_name = ""; // نام دیتابیس
```
همچنین اگر هاستتون چیزی جز localhost هست هم می تونید به سادگی مقدار متغیر $db_host رو ویرایش کنید.
#### اتصال ربات و کانال به اسکریپت
- در متغیر زیر، توکن ربات تلگرامی که ساختید رو قرار بدید:
```
$bot_token = "";
```
- در متغیر زیر، آیدی کانالتون رو قرار بدید. دقت کنید که قبل از آیدی حتما علامت - باشه. خودم یک مثال در متغیر زیر قرار دادم:
```
$chat_id = "-1002631234123";
```
سپس فایل رو ذخیره کنید و ببندید. اگر همه چیز رو درست تنظیم کردید، دیگه با این فایل کاری نداریم.
#### باز کردن فایل در مرورگر
برای اینکه مطمئن بشیم همه چیز به درستی تنظیم شده، فایل رو با استفاده از آدرسش روی هاستتون، یک بار در مرورگر اجرا کنید. اگر همه چیز درست انجام شده باشه، یک فایل sql به کانال تلگرامی که ایجاد کردید ارسال می شه.
#### تنظیم کرون جاب
در مرحله آخر، باید روی فایل db_to_tg.php کرون جاب ست کنید. زمان کرون جاب بستگی به میل خودتون و البته هماهنگی ای که با پشتیبانی هاستینگ انجام دادید داره.

## سخن پایانی
امیدوارم این اسکریپت براتون مفید باشه. خصوصا در این شرایط جنگی که بک آپ گیری سخت شده. من خودم دارم ازش استفاده می کنم و بنظر بدون هیچ مشکلی کار می کنه. با اینحال سعی می کنم با استفاده کنندگانش هم در تماس بمونم تا از سلامت اسکریپت مطمئن باشم. بسته به استقبال، احتمالا در آینده آپدیت هایی روش خواهیم داشت که امکانات بیشتری بهش بده. جا داره چند سوال متداول هم پاسخ بدم:
- چرا محدودیت 50 مگابایت وجود داره؟
محدودیت مربوط به تلگرام هست. ربات های تلگرام نمی تونن فایل بیشتر از 50 مگابایت رو آپلود کنند.(درحال حاضر که من این اسکریپت رو نوشتم اینطوریه)
- چرا به جای ارسال فایل های بکاپ به پیوی، اونا باید به یک کانال تلگرام ارسال بشن؟
این موضوع به این دلیل هست که بعضی عزیزان نیاز دارن تا اعضای تیمشون هم به فایل های بک آپ دسترسی داشته باشند. با این وجود، اگر شما نمی خواید از کانال تلگرام استفاده کنید هم دستتون باز هست. کافی هست در متغیر $chat_id به جای آیدی کانال، آیدی عددی اکانت خودتون رو قرار بدید. فقط قبلش باید یکبار رباتی که ساختید رو استارت بزنید تا براتون کار کنه.
- فرق بک آپ و بکاپ چیه؟ 
هیچی. اصلش کلمه backup هست. منتها در فارسی به دو صورت نوشته می شه. منم الان که دقت می کنم از هردوش در این توضیحات استفاده کردم.

ستاره و هر روش حمایتی در گیتهاب فراموش نشه:)
همچنین خوشحال میشم من رو در کانال تلگرامم هم همراهی کنید:) https://t.me/theAriaChannel